using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// This is the main tmWorldWidthpe for mWorldWidthour game
    /// </summarmy>
    public class ClassExample : XNACS1Base
    {
        RollingBall mBall, mLargeBall;
        XNACS1Rectangle mBackground;
        float mWorldWidth = 100;

        ExplosionParticle mAParticle;

        protected override void InitializeWorld()
        {
            mBackground = new XNACS1Rectangle(new Vector2(0, 0), 400, 400, "bgTexture");
            World.SetWorldCoordinate(new Vector2(0, 0), mWorldWidth);

            mBall = new RollingBall(World.WorldDimension * 0.5f, 1f);
            mLargeBall = new RollingBall(World.WorldDimension * 0.25f, 3f);



            // Particle
            mAParticle = null;
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            mBall.Update(GamePad.ThumbSticks.Right);
            mLargeBall.Update(GamePad.ThumbSticks.Right);

            if (null != mAParticle)
            {
                if (mAParticle.Update())
                    mAParticle = null;
            }


            mWorldWidth += GamePad.ThumbSticks.Left.X;

            // to support zoom with respect to mid-point of the world
            float worldHeight = mWorldWidth * 9f / 16f;
            Vector2 org = World.WorldMin;
            org.X -= (mWorldWidth - World.WorldDimension.X) / 2f;
            org.Y -= (worldHeight - World.WorldDimension.Y) / 2f;
            World.SetWorldCoordinate(org, mWorldWidth);
            ScrollWorld(mBall.Center);

            EchoToBottomStatus("Ball Velocity=" + mBall.Velocity + " Position=" + mBall.Center);

            if (GamePad.ButtonAClicked())
            {
                // Generate a particle randomly
                GenerateAParticle(mBall.Center);
            }
        }

        private void ScrollWorld(Vector2 pos)
        {
            Vector2 org = World.WorldMin;

            // now scroll according to location of the ball (left/right)
            float xPos = (pos.X - World.WorldMin.X);
            float rightMove = xPos - (0.9f * World.WorldDimension.X);
            float leftMove = xPos - (0.1f * World.WorldDimension.X);
            if (rightMove > 0f)
                org.X += rightMove;
            else if (leftMove < 0f)
                    org.X += leftMove;

            // now scroll up/down
            float yPos = (pos.Y - World.WorldMin.Y);
            float upMove = yPos - (0.9f * World.WorldDimension.Y);
            float downMove = yPos - (0.1f * World.WorldDimension.Y);

            if (upMove > 0f)
                org.Y += upMove;
            else if (downMove < 0f)
                org.Y += downMove;

            World.SetWorldCoordinate(org, mWorldWidth);
        }

        private void GenerateAParticle(Vector2 pos)
        {
            if (null != mAParticle)
                mAParticle.RemoveFromAutoDrawSet();

            Vector2 v = new Vector2(RandomFloat(-2f, 2f), RandomFloat(-2f, 2f));
            mAParticle = new ExplosionParticle(pos, v, 1f);
        }
    }
}
