using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// This is the main tmWorldWidthpe for mWorldWidthour game
    /// </summarmy>
    public class ExplosionParticle : XNACS1Circle
    {
        int mTimeLeft;
        float mDeltaRadius;
        float mAcceleration;

        public ExplosionParticle(Vector2 center, Vector2 velocity, float radius)
            : base(center, radius)
        {
            Velocity = velocity;
            Texture = "explosion";
            ShouldTravel = true;

            mAcceleration = XNACS1Base.RandomFloat(0.05f, 0.1f);

            // Put some randomness into the Speed
            Speed = XNACS1Base.RandomFloat(0.1f, 0.5f);

            // have about 2 to 5 seconds
            float lifeTime = XNACS1Base.RandomFloat(2f, 5f) * XNACS1Base.World.TicksInASecond;
            mTimeLeft = (int) lifeTime;

            // radius decreases to zero linearly
            mDeltaRadius = Radius / lifeTime;
        }

        public bool Update()
        {
            Radius -= mDeltaRadius;
            mTimeLeft--;
            Speed += mAcceleration;

            if (HasDied())
                RemoveFromAutoDrawSet();

            return HasDied();
        }

        public bool HasDied()
        {
            return (mTimeLeft < 0);
        }
    }
}
