using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// This is the main tmWorldWidthpe for mWorldWidthour game
    /// </summarmy>
    public class ParticleSystem
    {
        List<ExplosionParticle> mAllParticles;

        public ParticleSystem()
        {
            mAllParticles = new List<ExplosionParticle>();
        }

        public void Update()
        {
            int count = mAllParticles.Count;
            int nth = count - 1;
            while (nth >= 0)
            {
                ExplosionParticle p = mAllParticles[nth];
                if (p.Update())
                    mAllParticles.RemoveAt(nth);
                nth--;
            }
        }

        public void CreateParticles(Vector2 pos, int n)
        {
            Vector2 v = new Vector2();
            for (int i = 0; i < n; i++)
            {
                v.X = XNACS1Base.RandomFloat(-0.5f, 0.5f);
                v.Y = XNACS1Base.RandomFloat(-0.5f, 0.5f);
                ExplosionParticle p = new ExplosionParticle(pos, v,
                            XNACS1Base.RandomFloat(0.5f, 1.5f));
                mAllParticles.Add(p);
            }
        }

        // dir is the direciton to fire the particles
        // spread is the spread angle along the direction [spread is in degree]
        public void CreateParticles(Vector2 pos, Vector2 dir, float spread, int n)
        {
            dir.Normalize();
            Vector2 hDir = new Vector2(dir.Y, -dir.X);
            Vector2 v = new Vector2();

            double theta = spread * Math.PI / 180;
            float tanTheta = (float) Math.Tan(theta);
            for (int i = 0; i < n; i++)
            {
                float y = XNACS1Base.RandomFloat();
                float xRange = tanTheta * y;
                float x = XNACS1Base.RandomFloat(-xRange, xRange);
                v = x * hDir + y * dir;
                v.Normalize();
                ExplosionParticle p = new ExplosionParticle(pos, v, XNACS1Base.RandomFloat(0.5f, 1.5f));
                mAllParticles.Add(p);
            }
        }
    }
}
