using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// This is the main tmWorldWidthpe for mWorldWidthour game
    /// </summarmy>
    public class RollingBall : XNACS1Circle
    {
        Vector2 mBallVelocity;

        // the "new" keyword hides "Velocity" from parent.
        // Parent's Velocity and VelocityDirection are _NOT_ usable because of RotateAngle is tied to Velocity (BUG)
        public new Vector2 Velocity
        {
            set { mBallVelocity = value; }
            get { return mBallVelocity; }
        }

        public new float VelocityX
        {
            set { mBallVelocity.X = value; }
            get { return mBallVelocity.X; }
        }

        public new float VelocityY
        {
            set { mBallVelocity.Y = value; }
            get { return mBallVelocity.Y; }
        }

        public new float Speed
        {
            set
            {
                mBallVelocity.Normalize();
                mBallVelocity *= value;
            }
            get { return mBallVelocity.Length(); }
        }
                

        public RollingBall(Vector2 center, float radius)
            : base(center, radius)
        {
            Texture = "SoccerBall";
            mBallVelocity = new Vector2(0.1f, 0);
        }

        
        
        public void Update(Vector2 dv)
        {
            Velocity += dv * 0.1f;

            Center += Velocity;

            float angularDisplace = (Speed / Radius) * 180f / (float)Math.PI;
            // this assumes ball is rolling "on-top of" surfaces
            if (VelocityX < 0)
                RotateAngle += angularDisplace;
            else
                RotateAngle -= angularDisplace;
        }
    }
}
