using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class CircleWithMass : XNACS1Circle
    {
        public float Mass()
        {
            return (float) Math.PI * Radius * Radius;
        }

        // we are object-1, the colliding object is object-2
        protected void CollisionResponse(CircleWithMass c2)
        {
            // 1. compute normal
            Vector2 n = c2.Center - Center;
            float dist = n.Length();
            float overlapped = (c2.Radius + Radius) - dist;
            n /= dist;
            if (overlapped > 0)
            {
                overlapped *= 0.5f;
                // move each circles "backwards" according to their respective velocities
                c2.Center -= overlapped * c2.Velocity;
                Center -= overlapped * Velocity;
            }
            
            // 2. compute tangent
            Vector2 t = new Vector2(n.Y, -n.X);

            // velocity in the tangent direction no change!
            float v1t = Vector2.Dot(Velocity, t);
            float v2t = Vector2.Dot(c2.Velocity, t);

            // velocity in the normal direction 
            float v1n = Vector2.Dot(Velocity, n);
            float v2n = Vector2.Dot(c2.Velocity, n);

            // normal direction velocity changes to conserve momentum
            float v3n = ComputeResponseV.V1R(Mass(), v1n, c2.Mass(), v2n);
            float v4n = ComputeResponseV.V2R(Mass(), v1n, c2.Mass(), v2n);

            Velocity = v3n * n + v1t * t;
            c2.Velocity = v4n * n + v2t * t;
        }

        public void Update(CircleWithMass c2)
        {
            // 1. make sure we are within bounds
            BoundCollideStatus stat = XNACS1Base.World.ClampAtWorldBound(this);
            switch (stat)
            {
                case BoundCollideStatus.CollideBottom:
                case BoundCollideStatus.CollideTop:
                    VelocityY *= -1f;
                    break;

                case BoundCollideStatus.CollideLeft:
                case BoundCollideStatus.CollideRight:
                    VelocityX *= -1f;
                    break;
            }

            if ((null != c2) && (Collided(c2)))
            {
                CollisionResponse(c2);
            }
        }
    }
}