using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summary>
    /// 
    /// </summary>
    public class ComputeResponseV
    {
        // 
        // Object 1: V1, M1: resulting speed V1R
        // Object 2: V2, M2: resulting speed V2R
        //
        //   M1, M2: Mass of objects
        //   V1, V2: initial velocities (in the same direction)
        //   V1R, V2R: response velocities in the same direction
        // 
        public static float V1R(float M1, float V1, float M2, float V2)
        {
            return ((2 * M2 * V2) + (V1 * (M1 - M2))) / (M1 + M2);
        }

        public static float V2R(float M1, float V1, float M2, float V2)
        {
            return ((2 * M1 * V1) - (V2 * (M1 - M2))) / (M1 + M2);
        }
    }
}
