using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// This is the main tmWorldWidthpe for mWorldWidthour game
    /// </summarmy>
    public class ClassExample : XNACS1Base
    {
        Camera mMyCamera;

        XNACS1Circle mGuide;
        XNACS1Rectangle mBackground;
        
        protected override void InitializeWorld()
        {
            mBackground = new XNACS1Rectangle(new Vector2(0, 0), 400, 400, "bgTexture");
            mMyCamera = new Camera(new Vector2(50f, 30f), 100f);

            mGuide = new XNACS1Circle(new Vector2(50f, 30f), 2f, "SoccerBall");
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            mGuide.Center += GamePad.ThumbSticks.Right;

            mMyCamera.MoveCamera(GamePad.ThumbSticks.Left);
            
            if (GamePad.Buttons.A == ButtonState.Pressed)   // <-- zoom in
                mMyCamera.ZoomBy(-0.5f);

            if (GamePad.Buttons.B == ButtonState.Pressed)   // <-- zoom out
                mMyCamera.ZoomBy(0.5f);


            mMyCamera.KeepPointInSafeZone(mGuide.Center);

            EchoToBottomStatus("Guide Center=" + mGuide.Center);

        }

    }
}
