using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// 
    /// </summarmy>
    public class ClassExample : XNACS1Base
    {
        Camera mMyCamera;

        RollingBall mBall, mLargeBall;
        XNACS1Rectangle mBackground;
        
        protected override void InitializeWorld()
        {
            mBackground = new XNACS1Rectangle(new Vector2(0, 0), 400, 400, "bgTexture");
            mMyCamera = new Camera(new Vector2(50f, 30f), 100f);

            mBall = new RollingBall(World.WorldDimension * 0.5f, 1f);
            mLargeBall = new RollingBall(World.WorldDimension * 0.25f, 3f);
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            mBall.Update(GamePad.ThumbSticks.Right);
            mLargeBall.Update(GamePad.ThumbSticks.Right);

            mMyCamera.ZoomBy(GamePad.ThumbSticks.Left.X);
            mMyCamera.KeepPointInSafeZone(mBall.Center);

            EchoToBottomStatus("Ball Velocity=" + mBall.Velocity + " Position=" + mBall.Center);
        }

    }
}
