using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    
    public class RollingBall : XNACS1Circle
    {
        public RollingBall(Vector2 center, float radius)
            : base(center, radius)
        {
            Texture = "SoccerBall";
            VelocityX = 0.1f;
            VelocityY = 0.0f;
        }

        public void Update(Vector2 dv)
        {
            Velocity += dv * 0.1f;

            Center += Velocity;

            float angularDisplace = (Speed / Radius) * 180f / (float)Math.PI;
            // this assumes ball is rolling "on-top of" surfaces
            if (VelocityX < 0)
                RotateAngle += angularDisplace;
            else
                RotateAngle -= angularDisplace;
        }
    }
}
