using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class ClassExample : XNACS1Base
    {
        RollingBall mBall;
        XNACS1Rectangle mVelocity;

        float mFriction, mElasticity;

        const float kGravitationPull = 0.098f;

        protected override void InitializeWorld()
        {
            World.SetWorldCoordinate(new Vector2(0, 0), 200);
            mBall = new RollingBall(new Vector2(2, 2), 2);
            mBall.Velocity = new Vector2(1, 1);
            mBall.ShouldTravel = true;

            mVelocity = new XNACS1Rectangle(new Vector2(0, 0), new Vector2(5, 5), 2, "");
            mVelocity.Velocity = mBall.Velocity;

            mFriction = 0f;
            mElasticity = 1f;
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            #region The velocity bar
            Vector2 v = mVelocity.Velocity + GamePad.ThumbSticks.Right;
            mVelocity.SetEndPoints(new Vector2(0, 0), 5 * mVelocity.Velocity, 2f);
            mVelocity.Velocity = v;
            #endregion

            #region friction and elasticity set by user
            // friction and elasticity
            mFriction += 0.01f * GamePad.ThumbSticks.Left.X;
            mElasticity += 0.01f * GamePad.ThumbSticks.Left.Y;

            mFriction = MathHelper.Clamp(mFriction, 0f, 1f);
            mElasticity = MathHelper.Clamp(mElasticity, 0f, 1f);
            #endregion 

            #region shoot the ball
            if (GamePad.ButtonAClicked())
            {
                mBall.Center = new Vector2(mBall.Radius + 1f, mBall.Radius + 1f);
                mBall.Velocity = mVelocity.Velocity;
                mBall.SetToMotion();
            }
            #endregion 

            #region interact the ball with "physics
            mBall.Update(kGravitationPull, mFriction, mElasticity);
            #endregion

            EchoToTopStatus("Ball Velocity=" + mBall.Velocity);

            EchoToBottomStatus("(Left-Thumb-X)Friciton:" + mFriction + "   (Left-Thumb-Y)Elacitity:" + mElasticity);
        }
    }
}
