using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// 
    /// </summarmy>
    public class RollingBall : XNACS1Circle
    {
        const float kMySmallValue = 0.05f;
        enum BallState
        {
            eBallAtRest,
            eBallMoving
        };

        BallState mBallState;

        public RollingBall(Vector2 center, float radius)
            : base(center, radius)
        {
            Texture = "SoccerBall";
            VelocityX = 0.1f;
            VelocityY = 0.0f;
            SetToMotion();
        }

        public void SetToMotion()
        {
            mBallState = BallState.eBallMoving;
            ShouldTravel = true;
        }

        public void Update(float gravity, float friction, float elasticity)
        {
            switch (mBallState)
            {
                case BallState.eBallAtRest:
                    break;

                case BallState.eBallMoving:
                    UpdateBallPosition(gravity, friction, elasticity);
                    break;
            }
        }

        private void UpdateBallPosition(float gravity ,float friction, float elasticity)
        {
            // rotate the ball according to current velocity in X
            float angularDisplace = (VelocityX / Radius) * 180f / (float)Math.PI;
            RotateAngle -= angularDisplace;

            #region collide with world bound
            BoundCollideStatus stat = XNACS1Base.World.ClampAtWorldBound(this);
            switch (stat)
            {
                case BoundCollideStatus.CollideBottom:
                    VelocityY *= -elasticity;
                    break;

                case BoundCollideStatus.CollideTop:
                    VelocityY *= -1;
                    break;

                case BoundCollideStatus.CollideLeft:
                case BoundCollideStatus.CollideRight:
                    VelocityX *= -elasticity;
                    break;
            }
            #endregion 

            #region update by gravity and check for stopping condition
            float onTheFloorHeight = Radius+kMySmallValue;

            // assume we are colliding with the floor
            if (CenterY < onTheFloorHeight)
            {
                if (Math.Abs(VelocityY) < kMySmallValue)
                    VelocityY = 0f;
                else
                    VelocityY -= gravity;

                VelocityX *= (1 - friction);
            }
            else
            {
                VelocityY -= gravity;
            }

            // force the ball to stop in X
            if (Math.Abs(VelocityX) < float.Epsilon)
                VelocityX = 0f;
            #endregion

            if (!HasNonZeroVelocity())
            {
                mBallState = BallState.eBallAtRest;
                ShouldTravel = false;
            }
        }
    }
}
