using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class ClassExample : XNACS1Base
    {
        RollingBall mBall;
        XNACS1Rectangle mVelocity;

        FakeCollisionPhysics mFakePhysics;

        protected override void InitializeWorld()
        {
            World.SetWorldCoordinate(new Vector2(0, 0), 200);
            mBall = new RollingBall(new Vector2(2, 2), 2);
            mBall.Velocity = new Vector2(1, 1);
            mBall.ShouldTravel = true;

            mVelocity = new XNACS1Rectangle(new Vector2(0, 0), new Vector2(5, 5), 2, "");
            mVelocity.Velocity = mBall.Velocity;

            mFakePhysics = new FakeCollisionPhysics();
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            #region The velocity bar
            Vector2 v = mVelocity.Velocity + GamePad.ThumbSticks.Right;
            mVelocity.SetEndPoints(new Vector2(0, 0), 5 * mVelocity.Velocity, 2f);
            mVelocity.Velocity = v;
            #endregion

            #region friction and elasticity set by user
            // friction and elasticity
            mFakePhysics.Friction += 0.01f * GamePad.ThumbSticks.Left.X;
            mFakePhysics.Elasticity += 0.01f * GamePad.ThumbSticks.Left.Y;
            #endregion 

            #region shoot the ball
            if (GamePad.ButtonAClicked())
            {
                mBall.Center = new Vector2(mBall.Radius + 1f, mBall.Radius + 1f);
                mBall.Velocity = mVelocity.Velocity;
                mBall.SetToMotion();
            }
            #endregion 

            #region interact the ball with "physics
            mBall.Update(mFakePhysics);
            #endregion

            EchoToTopStatus("Ball Velocity=" + mBall.Velocity);

            EchoToBottomStatus("(Left-Thumb-X)Friciton:" + mFakePhysics.Friction + "   (Left-Thumb-Y)Elacitity:" + mFakePhysics.Elasticity);
        }
    }
}
