using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// 
    /// </summarmy>
    public class RollingBall : XNACS1Circle
    {
        const float kMySmallValue = 0.05f;
        enum BallState
        {
            eBallAtRest,
            eBallMoving
        };

        BallState mBallState;

        public RollingBall(Vector2 center, float radius)
            : base(center, radius)
        {
            Texture = "SoccerBall";
            VelocityX = 0.1f;
            VelocityY = 0.0f;
            SetToMotion();
        }

        public void SetToMotion()
        {
            mBallState = BallState.eBallMoving;
            ShouldTravel = true;
        }

        public void Update(FakeCollisionPhysics physics)
        {
            switch (mBallState)
            {
                case BallState.eBallAtRest:
                    break;

                case BallState.eBallMoving:
                    UpdateBallPosition(physics);
                    break;
            }
        }

        private void UpdateBallPosition(FakeCollisionPhysics physics)
        {
            // rotate the ball according to current velocity in X
            float angularDisplace = (VelocityX / Radius) * 180f / (float)Math.PI;
            RotateAngle -= angularDisplace;

            #region collide with world bound
            BoundCollideStatus stat = XNACS1Base.World.ClampAtWorldBound(this);
            switch (stat)
            {
                case BoundCollideStatus.CollideBottom:
                    // VelocityY *= -1f;
                    // should not happen as our FakePhysics should take care of this for us!!
                    break;

                case BoundCollideStatus.CollideTop:
                    VelocityY *= -1f;
                    break;

                case BoundCollideStatus.CollideLeft:
                case BoundCollideStatus.CollideRight:
                    VelocityX *= -1f;
                    break;
            }
            #endregion 

            // Update with Physics
            physics.UpdateByFakePhysics(this);

            // State transition
            if (!HasNonZeroVelocity())
            {
                mBallState = BallState.eBallAtRest;
                ShouldTravel = false;
            }
            else
            {
                VelocityY -= FakeGravity.Gravity;
            }
        }
    }
}
