using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// 
    /// </summarmy>
    public class FakeCollisionPhysics
    {
        private const float kMySmallValue = 0.05f;
        private float mElasticity = 0.9f;
        private float mFriction = 0f;

        public FakeCollisionPhysics()
        { }

        #region accessors
        public float Elasticity { set { mElasticity = MathHelper.Clamp(value, 0f, 1f); } get { return mElasticity; } }
        public float Friction { set { mFriction = MathHelper.Clamp(value, 0f, 1f); } get { return mFriction; } }
        #endregion 


        public void UpdateByFakePhysics(XNACS1Circle circle)
        {
            if (!circle.HasNonZeroVelocity())
                return;

            float error = circle.Radius * kMySmallValue; // 5% of the circle radius
            float onTheFloorHeight = circle.Radius + error; 

            // assume we are colliding with the floor
            if ( (circle.CenterY < onTheFloorHeight) && (circle.VelocityY < 0f) )
            {
                if (circle.CenterY < circle.Radius)
                    circle.VelocityY += FakeGravity.Gravity; // went into the floor! fix this!!
                
                // set the radius to be exactly on the floor
                circle.CenterY = circle.Radius;   // "push the circle out of the floor" sounds familiar?

                // stop the circle
                if (Math.Abs(circle.VelocityY) < error)
                    circle.VelocityY = 0f;

                circle.VelocityX *= (1 - mFriction);
                circle.VelocityY = mElasticity * Math.Abs(circle.VelocityY);
            }

            // force the ball to stop in X
            if (Math.Abs(circle.VelocityX) < float.Epsilon)
                circle.VelocityX = 0f;
        }

    }
}
