using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class ClassExample : XNACS1Base
    {
        RollingBall mBall;
        XNACS1Rectangle mVelocity;

        SolidBlockWithPhysics mFloor;
        List<SolidBlockWithPhysics> mPlanks;
        SolidBlockWithPhysics mCurrentPlank;
        int mCurrentPlankIndex;

        const int kNumPlanks = 6;

        protected override void InitializeWorld()
        {
            World.SetWorldCoordinate(new Vector2(0, 0), 200);

            mFloor = new SolidBlockWithPhysics(
                    new Vector2(0.5f * (World.WorldMax.X + World.WorldMin.X), 0f),  // center of the block
                    World.WorldDimension.X, 4f);        // Width and Height

            // The planks ...
            mPlanks = new List<SolidBlockWithPhysics>();
            mPlanks.Add(mFloor);

            BuildThePlanks();

            // The ball
            mBall = new RollingBall(new Vector2(2, 2), 2);
            mBall.Velocity = new Vector2(1, 1);
            mBall.ShouldTravel = true;

            mVelocity = new XNACS1Rectangle(new Vector2(0, 0), new Vector2(5, 5), 2, "");
            mVelocity.Velocity = mBall.Velocity;
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            #region The velocity bar
            Vector2 v = mVelocity.Velocity + GamePad.ThumbSticks.Right;
            mVelocity.SetEndPoints(new Vector2(0, 0), 5 * mVelocity.Velocity, 2f);
            mVelocity.Velocity = v;
            #endregion

            #region friction and elasticity set by user
            // friction and elasticity
            mCurrentPlank.Friction += 0.01f * GamePad.ThumbSticks.Left.X;
            mCurrentPlank.Elasticity += 0.01f * GamePad.ThumbSticks.Left.Y;
            mCurrentPlank.RotateAngle += (GamePad.Triggers.Left * -1 * 10) + (GamePad.Triggers.Right * 10);
            #endregion

            #region select next plank with X-button
            if (GamePad.ButtonXClicked())
            {
                mCurrentPlank.Color = Color.LightGreen;
                mCurrentPlankIndex++;
                if (mCurrentPlankIndex >= kNumPlanks)
                    mCurrentPlankIndex = 0;
                mCurrentPlank = mPlanks[mCurrentPlankIndex];
                mCurrentPlank.Color = Color.Red;
            }
            #endregion 

            #region shoot the ball
            if (GamePad.ButtonAClicked())
            {
                mBall.Center = new Vector2(mBall.Radius + 1f, mBall.Radius + 1f);
                mBall.Velocity = mVelocity.Velocity;
                mBall.SetToMotion();
            }
            #endregion 

            #region rebuild the planks
            if (GamePad.ButtonBClicked())
                BuildThePlanks();
            #endregion 

            #region interact the ball with "physics
            mBall.Update();

            foreach (SolidBlockWithPhysics s in mPlanks)
            {
                s.Update(mBall);
            }

            #endregion

            EchoToTopStatus("Ball Velocity=" + mBall.Velocity);

            EchoToBottomStatus("(Left-Thumb-X)Friciton:" + mCurrentPlank.Friction + 
                            "   (Left-Thumb-Y)Elacitity:" + mCurrentPlank.Elasticity);
        }


        // the planks ...
        private void BuildThePlanks()
        {
            // remove first ..
            for (int i=mPlanks.Count-1; i>=1; i--)
            {
                SolidBlockWithPhysics s = mPlanks[i];
                s.RemoveFromAutoDrawSet();
                mPlanks.RemoveAt(i);
            }

            float xPos = 20f;
            for (int i = 1; i < kNumPlanks; i++)
            {
                SolidBlockWithPhysics s = new SolidBlockWithPhysics(
                        new Vector2(RandomFloat(xPos - 10f, xPos + 10f), RandomFloat(10f, 100f)), // center
                        RandomFloat(30f, 60f), // width
                        RandomFloat(4f, 6f));  // height;
                s.Color = Color.LightGreen;
                mPlanks.Add(s);
                xPos += 40f;
            }
            mCurrentPlankIndex = 0;
            mCurrentPlank = mPlanks[mCurrentPlankIndex];
            mCurrentPlank.Color = Color.Red;
        }
    }
}
