using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summarmy>
    /// 
    /// </summarmy>
    public class SolidBlock : XNACS1Rectangle
    {
        public SolidBlock(Vector2 center, float width, float height)
            : base(center, width, height)
        { }


        /// <summary>
        ///  Collides and ensure
        /// </summary>
        /// <param name="circle"></param>
        public void Update(XNACS1Circle circle)
        {
            if (!circle.HasNonZeroVelocity())
                return;

            if (Collided(circle))
            {
                Vector2 T = FrontDirection;                   // this is the Tangent vector

                Vector2 V = circle.Center - Center;           // from block to current Center
                float d_T = Vector2.Dot(V, T);                // Project V on in the T direction ** a signed-value **
                Vector2 pt_T = Center + (d_T * T);            // Point on Tangent vector
                Vector2 N = circle.Center - pt_T;             // Normal (or perpendicualr vector) to the block
                N.Normalize();
                float d_N = Vector2.Dot(V, N);                // Project V in the N direction ** a signed-value **
                //     Reason we normalize N and then do the dot and _NOT_
                //         d_N = N.Length()
                //         N = N / d_N
                //     is because in this case, d_N is an absolute value and we have
                //     lost the "directionality" of d_N

                // Now the velocity ...
                float velocity_T = Vector2.Dot(circle.Velocity, T);        // velocity component on the Tangent direction
                float velocity_N = Vector2.Dot(circle.Velocity, N);       // velocity component on the Normal direction


                if (Math.Abs(d_T) < (Width / 2f))
                {
                    // solve for top/bottom overlap
                    float displacementOnN = circle.Radius + (Height / 2f);
                    if (Math.Abs(d_N) < displacementOnN)
                    {
                        circle.Center = pt_T + Math.Sign(d_N) * (displacementOnN * N);
                        circle.Velocity = (-velocity_N * N + velocity_T * T);
                    }
                }
                else
                {
                    // solve for side overlap
                    float displacementOnT = circle.Radius + (Width / 2f);
                    if (Math.Abs(d_T) < displacementOnT)
                    {
                        circle.Center = Center + (d_N * N) + Math.Sign(d_T) * (displacementOnT * T);
                        circle.Velocity = (velocity_N * N - velocity_T * T);
                    }
                }
            }
        }
    }
}