using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using XNACS1Lib;

namespace ClassExample
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class ClassExample : XNACS1Base
    {
        const float kWorldWidth = 500f;

        const float kGravity = -0.98f;
        const float kProjectileRadius = 2f;
        const float kVelocityWidth = 1f;
        const float kTargetSize = kProjectileRadius*5f;
        const float kProjectileInitX = 20f;
        const float kProjectileInitY = 35f;

        XNACS1Circle mTheProjectile;
        int mTravelTime;
        float mMaxHeight;

        XNACS1PrimitiveSet mProjectileSet;
        XNACS1Rectangle mInitVelocity;
        XNACS1Rectangle mPredictTarget;
        XNACS1Rectangle mHightestPoint;
          
        protected override void InitializeWorld()
        {
            World.SetWorldCoordinate(new Vector2(0f, 0f), kWorldWidth);

            mPredictTarget = new XNACS1Rectangle();
            mPredictTarget.Color = Color.Black;
            mPredictTarget.Width = kTargetSize;
            mPredictTarget.Height = 1;

            mHightestPoint = new XNACS1Rectangle();
            mHightestPoint.Color = Color.White;
            mHightestPoint.Width = 10f;
            mHightestPoint.Height = 1f;

            mInitVelocity = new XNACS1Rectangle();
            mInitVelocity.Velocity = new Vector2(2, 2);

            mProjectileSet = new XNACS1PrimitiveSet();

            mTheProjectile = new XNACS1Circle();
            mTheProjectile.Color = Color.White;
            mTheProjectile.Label = "The Projectile";
            mTheProjectile.Radius = 2 * kProjectileRadius;
        }

        protected override void UpdateWorld()
        {
            if (GamePad.ButtonBackClicked())
                Exit();

            Vector2 v = mInitVelocity.Velocity;
            mInitVelocity.SetEndPoints(new Vector2(0, 0), mInitVelocity.Velocity, 2f);
            mInitVelocity.Velocity = v + (0.2f * GamePad.ThumbSticks.Right);

            if (mTheProjectile.ShouldTravel)
            {
                // Position of mTheProjectile is changed by its velocity befor we have the opportunity
                // to update the velocity (will follow the green trace)
                mTheProjectile.VelocityY += kGravity;

                // make sure this is in bound
                if (mTheProjectile.CenterY <= kProjectileInitY)
                {
                    mTheProjectile.ShouldTravel = false;
                }
                else
                {
                    mTravelTime++;
                    if (mTheProjectile.CenterY > mMaxHeight)
                        mMaxHeight = mTheProjectile.CenterY;
                }
            }

            if (GamePad.ButtonAClicked())
            {
                mTheProjectile.TopOfAutoDrawSet();
                mTheProjectile.ShouldTravel = true;
                mTheProjectile.Velocity = mInitVelocity.Velocity;
                mTheProjectile.CenterX = kProjectileInitX;
                mTheProjectile.CenterY = kProjectileInitY;

                mTravelTime = 0;
                mMaxHeight = kProjectileInitY;
            }

            
            ComputeTargetPosition();
            ShowProjectiles();

            EchoToBottomStatus("Initial Velocity:" + mInitVelocity.Velocity + " CurrentTravel: Time=" + mTravelTime + " MaxYDisplacement=" + (mMaxHeight-kProjectileInitY));
        }

        private void ComputeTargetPosition()
        {
            // using the current Projectile velocity to compute the x position where it will land
            if (mInitVelocity.VelocityY != 0f)
            {
                float useVelocity = mInitVelocity.VelocityY; 
                float tmToHitYMax = useVelocity / Math.Abs(kGravity);
                tmToHitYMax += 0.5f;  // use the middle of the update (average)

                // recognizing position is changed before velocity
                float initYDisplacement = useVelocity * (tmToHitYMax + 0.5f);

                float xDisplacement = tmToHitYMax * mInitVelocity.VelocityX;

                float yDisplacement = initYDisplacement + 0.5f * kGravity * tmToHitYMax * tmToHitYMax;
                mHightestPoint.CenterX = kProjectileInitX + xDisplacement;
                mHightestPoint.CenterY = kProjectileInitY + yDisplacement;
                mHightestPoint.AddToAutoDrawSet();

                mPredictTarget.CenterX = kProjectileInitX + xDisplacement + xDisplacement;
                mPredictTarget.CenterY = kProjectileInitY;
                mPredictTarget.AddToAutoDrawSet();
                EchoToTopStatus("Predict, traveling time=" + 2 * tmToHitYMax + " YDisplacement=" + yDisplacement + " Xdisplacement=" + xDisplacement * 2f);

            } else {
                mPredictTarget.RemoveFromAutoDrawSet();
                mHightestPoint.RemoveFromAutoDrawSet();
            }
        }

        private void ShowProjectiles()
        {
            float x = kProjectileInitX;
            float vx = mInitVelocity.VelocityX;

            // red ball position and velocity
            float ry = kProjectileInitY;
            float rvy = mInitVelocity.VelocityY;

            // green ball position and velocity
            float gy = kProjectileInitY;
            float gvy = mInitVelocity.VelocityY;

            // blue ball position is the average of red and green

            mProjectileSet.RemoveAllFromSet();

            while ((ry >= kProjectileInitY) || (gy >= kProjectileInitY))
            {
                // Red balls update velocity before update y position
                XNACS1Circle c = new XNACS1Circle(new Vector2(x, ry), kProjectileRadius);
                c.Color = Color.Red;
                mProjectileSet.AddToSet(c);
                

                // green balls, update y position before update velocity
                c = new XNACS1Circle(new Vector2(x, gy), kProjectileRadius);
                c.Color = Color.Green;
                mProjectileSet.AddToSet(c);
                
                x += vx;

                // For green trace, update position before update velocity
                gy += gvy;
                gvy += kGravity;

                //For red trace, update velocity before update position
                rvy += kGravity;
                ry += rvy;
            }
        }
    }
}
