#pragma once

#include "WtlWindow.h"

class CWtlFrame : public CFrameWindowImpl<CWtlFrame>, 
					public CUpdateUI<CWtlFrame>
{
public:
	DECLARE_FRAME_WND_CLASS(NULL, IDR_MAINFRAME)

	// global variable for the window you will create
	CWtlWindow m_View;

	// translate window messages
	virtual BOOL PreTranslateMessage(MSG* pMsg)
	{
		// if it is for the main frame, handle it
		if (CFrameWindowImpl<CWtlFrame>::PreTranslateMessage(pMsg))
			return true;

		// otherwise, let the displayed window handle it
		return m_View.PreTranslateMessage(pMsg);
	}

	// UI update map
	BEGIN_UPDATE_UI_MAP(CMainFrame)
		UPDATE_ELEMENT(ID_VIEW_STATUS_BAR, UPDUI_MENUPOPUP)
	END_UPDATE_UI_MAP()

	// map window messages to message handlers
	BEGIN_MSG_MAP(CWtlFrame)
		MESSAGE_HANDLER(WM_CREATE, OnCreate)
		COMMAND_ID_HANDLER(ID_APP_EXIT, OnFileExit)
		CHAIN_MSG_MAP(CUpdateUI<CWtlFrame>)
		CHAIN_MSG_MAP(CFrameWindowImpl<CWtlFrame>)
	END_MSG_MAP()

	LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, 
				LPARAM /*lParam*/, BOOL& /*bHandled*/);

	LRESULT OnFileExit(WORD /*wNotifyCode*/, WORD /*wID*/, HWND 
				/*hWndCtl*/, BOOL& /*bHandled*/);
};