#include "WtlWindow.h"
#include <string>
#include ".\wtlwindow.h"
using namespace::std;

// message handler for when window is shown -- you can
// initialize stuff here
LRESULT CWtlWindow::OnShow(UINT /*uMsg*/, WPARAM /*wParam*/, 
		LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	// initialize the edit box
	LPTSTR bnText = "Peanut butter sandwiches...";
	SetDlgItemText(IDC_EDIT_BOX, bnText);

	// initialize option 1 to "selected"
	m_bnRadio1 = GetDlgItem(IDC_RADIO_OPT1);
	m_bnRadio1.SetCheck(1);

	// set up the scroll bars
	m_sliderBarVert = GetDlgItem(IDC_SLIDER_VERT);
	m_sliderBarHorz = GetDlgItem(IDC_SLIDER_HORZ);
	m_sliderBarVert.SetRange(0, 50, true);
	m_sliderBarHorz.SetRange(0, 100, true);
	m_sliderBarVert.SetPos(50);

	// start the timer
	SetTimer(1, 1000);

	return 0;
}

LRESULT CWtlWindow::OnTimer(UINT /*uMsg*/, WPARAM /*wParam*/, 
		LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	static int seconds = 0;
	char szTimer[10];
	char szMessage[20];
	seconds++;

	if (seconds < 60)
	{
		itoa(seconds, szTimer, 10);
		if (seconds < 10)
		{
			strcpy(szMessage, "Timer = 0:0");
		}
		else
		{
			strcpy(szMessage, "Timer = 0:");
		}
		strcat(szMessage, szTimer);
		m_StaticTmr = szMessage;
		DoDataExchange(false, IDC_STATIC_TMR);
	}

	return 0;
}

// message handler for when 'Modify' button is clicked
LRESULT CWtlWindow::OnBnClickedModify(WORD /*wNotifyCode*/, WORD /*wID*/, 
				HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	char temp[50];
	LPTSTR bnText = temp;

	// get the current button text
	GetDlgItemText(IDC_BN_MODIFY, bnText, 50);

	// choose a new text string
	if (strcmp("Modify", bnText) == 0)
	{
		bnText = "button...";
	}
	else
	{
		bnText = "Modify";
	}

	// modify the button text with the new value
	SetDlgItemText(IDC_BN_MODIFY, bnText);

	return 0;
}

// message handler for the 'Count' button click message
LRESULT CWtlWindow::OnBnClickedCount(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static int clickCount = 0;

	clickCount++;

	// update the click count
	char temp[4];
	itoa(clickCount, temp, 10);
	char msg[50] = "Button clicks: ";
	strcat(msg, temp);

	// update the static text control
	m_StaticMsg = msg;
	DoDataExchange(false, IDC_STATIC_MSG);

	return 0;
}

// message handler for the 'Edit' button click message
LRESULT CWtlWindow::OnBnClickedEdit(WORD /*wNotifyCode*/, WORD /*wID*/, 
	HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	char temp[50];
	LPTSTR bnText = temp;

	// get the current button text
	GetDlgItemText(IDC_EDIT_BOX, bnText, 50);

	// update the static text control
	m_StaticMsg = bnText;
	DoDataExchange(false, IDC_STATIC_MSG);

	return 0;
}

LRESULT CWtlWindow::OnBnClickedRadio1(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// update the message
	m_StaticMsg = "User selected option #1";
	DoDataExchange(false, IDC_STATIC_MSG);

	return 0;
}

LRESULT CWtlWindow::OnBnClickedRadio2(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	// update the message
	m_StaticMsg = "User selected option #2";
	DoDataExchange(false, IDC_STATIC_MSG);
	
	return 0;
}

LRESULT CWtlWindow::OnHorzScroll(UINT uMsg, WPARAM wParam, LPARAM 
		lParam, BOOL& /*bHandled*/)
{
	char sText[5];
	LPTSTR pText = sText;
	int nPos = m_sliderBarHorz.GetPos();
	GetDlgItemText(IDC_STATIC_HORZ, pText, 5);
	if (nPos != atoi(pText))
	{
		itoa(nPos, pText, 10);
		SetDlgItemText(IDC_STATIC_HORZ, pText);
	}
	return 0;
}

LRESULT CWtlWindow::OnVertScroll(UINT uMsg, WPARAM wParam, LPARAM 
		lParam, BOOL& /*bHandled*/)
{
	char sText[5];
	LPTSTR pText = sText;
	int nPos = 50 - m_sliderBarVert.GetPos();
	GetDlgItemText(IDC_STATIC_VERT, pText, 5);
	if (nPos != atoi(pText))
	{
		itoa(nPos, pText, 10);
		SetDlgItemText(IDC_STATIC_VERT, pText);
	}
	return 0;
}
