#pragma once

#include "stdafx.h"

class CWtlWindow : public CDialogImpl<CWtlWindow>,
					public CWinDataExchange<CWtlWindow>
{
public:
	enum { IDD = IDD_WTL_VIEW };

	// translate window messages
	BOOL PreTranslateMessage(MSG* pMsg)
	{
		return IsDialogMessage(pMsg);
	}

	// map messages to custom message handlers
	BEGIN_MSG_MAP(CWtlWindow)
		MESSAGE_HANDLER(WM_SHOWWINDOW, OnShow)
		MESSAGE_HANDLER(WM_TIMER, OnTimer)
		COMMAND_HANDLER(IDC_BN_MODIFY, BN_CLICKED, OnBnClickedModify)
		COMMAND_HANDLER(IDC_BN_COUNT, BN_CLICKED, OnBnClickedCount)
		COMMAND_HANDLER(IDC_BN_EDIT, BN_CLICKED, OnBnClickedEdit)
		COMMAND_HANDLER(IDC_RADIO_OPT1, BN_CLICKED, OnBnClickedRadio1)
		COMMAND_HANDLER(IDC_RADIO_OPT2, BN_CLICKED, OnBnClickedRadio2)
		MESSAGE_HANDLER(WM_HSCROLL, OnHorzScroll)
		MESSAGE_HANDLER(WM_VSCROLL, OnVertScroll)
	END_MSG_MAP()

	BEGIN_DDX_MAP(CWtlWindow)
		DDX_TEXT(IDC_STATIC_MSG, m_StaticMsg)
		DDX_TEXT(IDC_STATIC_TMR, m_StaticTmr)
	END_DDX_MAP()

	LRESULT OnShow(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM 
		/*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnTimer(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM 
		/*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedModify(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedCount(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedEdit(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedRadio1(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnBnClickedRadio2(WORD /*wNotifyCode*/, WORD /*wID*/, 
		HWND /*hWndCtl*/, BOOL& /*bHandled*/);
	LRESULT OnHorzScroll(UINT uMsg, WPARAM wParam, LPARAM 
		lParam, BOOL& /*bHandled*/);
	LRESULT OnVertScroll(UINT uMsg, WPARAM wParam, LPARAM 
		lParam, BOOL& /*bHandled*/);

private:
	LPTSTR m_StaticMsg;
	LPTSTR m_StaticTmr;
	CButton m_bnRadio1;
	CTrackBarCtrl m_sliderBarHorz;
	CTrackBarCtrl m_sliderBarVert;
public:
	LRESULT OnNMCustomdrawSliderVert(int /*idCtrl*/, LPNMHDR pNMHDR, BOOL& /*bHandled*/);
};
