﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

namespace MyFirstApp
{
    public partial class PageOne : PhoneApplicationPage
    {

        #region Here is the "State" of my application
        int mCount = 0;
        #endregion 

        // Constructor
        public PageOne()
        {
            // Can delay loading if we want. 
            System.Threading.Thread.Sleep(100);
            //
            InitializeComponent();

            // Initialize the "state" of my applications
            mCount = 1;


            // Initialize Component allocates/initialize all UIElements
            // After InitializeComponent is done, we can start using
            // the UIElements
            EchoApplicationState();
        }

        #region Support for echoing state
        private void EchoApplicationState()
        {
            mStatusEcho.Text = "The value is:" + mCount;
            mTextBox.Text = "The value is:" + mCount;
        }
        #endregion 
        
        #region Support Count Button Event
        private void mCountBtn_Click(object sender, RoutedEventArgs e)
        {
            mCount += 1;
            EchoApplicationState();
        }
        #endregion 

        #region Text Input Service routines
        private void TextInputBegins(object sender, RoutedEventArgs e)
        {
            mTextBox.SelectAll();
        }

        private void TextInputDone(object sender, RoutedEventArgs e)
        {
            int n;
            if (Int32.TryParse(mTextBox.Text, out n))
            {
                mCount = n;
                EchoApplicationState();
            }
            else
            {
                mStatusEcho.Text = "Input not a number";
            }
        }
        #endregion
    }
}