﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace MyFirstApp
{
    public class AppState
    {
        // this is my application state
        private int mCount = 1;

        public AppState()
        {
            mCount = 1;
        }

        /// <summary>
        /// Attempt to update the application state with the input
        /// string. Returns status of the update.
        /// 
        /// Only success if input is a 32-bit integer for now.
        /// 
        /// </summary>
        /// <param name="msg">Message to update application state</param>
        /// <returns></returns>
        public bool UpdateAppState(string msg)
        {
            int n;
            bool status = Int32.TryParse(msg, out n);

            if (status)
                mCount = n;
            return status;
        }

        /// <summary>
        ///  Always update the application state
        /// </summary>
        public void UpdateAppState()
        {
            mCount++;
        }

        public string PrintAppState() { return mCount.ToString(); }
    }
}
