﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

// to get Dispatch timer
using System.Windows.Threading;

namespace MyFirstApp
{
    public partial class PageOne : PhoneApplicationPage
    {
        #region Timer Support
        // The timer ...
        DispatcherTimer mTimer = new DispatcherTimer();
        // current time, accurate, probably to 100 nano-second
        DateTime mBeginTime = DateTime.Now; // for reference
        SolidColorBrush mColorBrush = new SolidColorBrush(Color.FromArgb(255, 128, 0, 128));
        #endregion 

        #region Here is the "State" of my application
        AppState mAppState;
        #endregion 

        // Constructor
        public PageOne()
        {
            // Can delay loading if we want. 
            // System.Threading.Thread.Sleep(100);
            //
            InitializeComponent();

            // Initialize the "state" of my applications
            mAppState = new AppState();

            // Initialize Component allocates/initialize all UIElements
            // After InitializeComponent is done, we can start using
            // the UIElements
            EchoApplicationState();

            #region Timer initialization
            // Updatres every 40 milli second
            mTimer.Interval = TimeSpan.FromMilliseconds(40);
            mTimer.Tick += TimerUpdateRountine;  // What to do when timer ticks
            mTimer.Start();                      // starts the timer

            // The background fill color
            mTimerEcho.Foreground = mColorBrush;
            #endregion 
        }


        #region Time Service Routine
        private void TimerUpdateRountine(object sender, EventArgs e)
        {
            DateTime c = DateTime.Now;              // current time
            TimeSpan s = c.Subtract(mBeginTime);    // Subtract from the beginning time

            mTimerEcho.Text = string.Empty;
            if (s.Seconds > 0)
                mTimerEcho.Text = s.Seconds.ToString() + ":";

            mTimerEcho.Text += s.Milliseconds.ToString();

            // cycle the color of the background sign
            Color useColor = mColorBrush.Color;
            useColor.G++;
            mColorBrush.Color = useColor;
            mTimerEcho.Foreground = mColorBrush;
        }
        #endregion

        #region Support for echoing state
        private void EchoApplicationState()
        {
            mStatusEcho.Text = "The value is:" + mAppState.PrintAppState();
            mTextBox.Text = "The value is:" + mAppState.PrintAppState();
        }
        #endregion 
        
        #region Support Count Button Event
        private void mCountBtn_Click(object sender, RoutedEventArgs e)
        {
            mAppState.UpdateAppState();
            EchoApplicationState();
        }
        #endregion 

        #region Text Input Service routines
        private void TextInputBegins(object sender, RoutedEventArgs e)
        {
            mTextBox.SelectAll();
        }

        private void TextInputDone(object sender, RoutedEventArgs e)
        {
            if (mAppState.UpdateAppState(mTextBox.Text))
            {
                EchoApplicationState();
            }
            else
            {
                mStatusEcho.Text = "Invalid input";
            }
        }
        #endregion

    }
}