﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls; 

namespace EventRouting
{
    public partial class MainPage : PhoneApplicationPage
    {
        /// <summary>
        /// Constructor: Initialize count label
        /// </summary>
        public MainPage()
        {
            InitializeComponent();
            mStatus.Text = "";
        }
        
        #region GrandParent Canvas
        // Grandparent canvas: Three service routines, depending on if any of 
        // the children override the same events and if the children "handled" the event
        // these service routines may or may not be called!

        /// <summary>
        /// Grandparent's Manipulation service routines
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void GrandParentStarted(object sender, System.Windows.Input.ManipulationStartedEventArgs e)
        {
            mStatus.Text += "grandStart: ";
        }
        private void GrandParentDelta(object sender, ManipulationDeltaEventArgs e)
        {
            mStatus.Text += "grandDelta: ";
        }

        private void GrandParentCompleted(object sender, ManipulationCompletedEventArgs e)
        {
            mStatus.Text += "grandCompleted: ";
        }
        #endregion

        #region Parent Canvas
        // Parent canvas: Three service routines, depending on if any of 
        // the children override the same events and if the children "handled" the event
        // these service routines may or may not be called!

        /// <summary>
        /// Parent's Manipulation service routines
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ParentStarted(object sender, System.Windows.Input.ManipulationStartedEventArgs e)
        {
            mStatus.Text += "parentStart: ";
        }
        private void ParentDelta(object sender, ManipulationDeltaEventArgs e)
        {
            mStatus.Text += "parentDelta: ";
            e.Handled = true;   // <-- blocks this from our parent (the GrandParentDelta will not see this event)!!
        }
        private void ParentCompleted(object sender, ManipulationCompletedEventArgs e)
        {
            mStatus.Text += "parentCompleted: ";
        }
        #endregion


        #region Child canvas services
        // Child canvas: Three service routines, in this example, the child is the leaf, so it 
        // has option of "Handled" events, or forward the event on to its Parent

        /// <summary>
        /// Child's Manipulation service routines
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ChildStarted(object sender, System.Windows.Input.ManipulationStartedEventArgs e)
        {
            mStatus.Text += "childStart: ";
        }
        private void ChildDelta(object sender, ManipulationDeltaEventArgs e)
        {
            mStatus.Text += "childDelta: ";
        }
        private void ChildCompleted(object sender, ManipulationCompletedEventArgs e)
        {
            mStatus.Text += "childCompleted: ";
            e.Handled = true;   // <-- blocks this from our parent (the ParentCompleted will not see this event)!!
        }
        #endregion

        #region Status Button Service routines

        /// notice the multiple ways of handling events, and the fact that 
        ///    some routines "Handled" the events by default
        ///    E.g., Click: consumes the events while
        ///          But

        /// <summary>
        /// Clear the status area
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void StatusButtonClicked(object sender, System.Windows.RoutedEventArgs e)
        {
            mStatus.Text = "";
        }

        #region Button Canvas, defined under the Button, to block all Manipulation events from the Grandparent
        /// <summary>
        /// Button canvas's Manipulation service routines: simply blocking everything
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ButtonStarted(object sender, System.Windows.Input.ManipulationStartedEventArgs e)
        {
            mClearStatusButton.Content = "Started";
            e.Handled = true;
        }
        private void ButtonDelta(object sender, ManipulationDeltaEventArgs e)
        {
            mClearStatusButton.Content = "Delta";
            e.Handled = true;
        }
        private void ButtonCompleted(object sender, ManipulationCompletedEventArgs e)
        {
            mClearStatusButton.Content = "Clear Status";
            e.Handled = true;   // <-- blocks this from our parent (the ParentCompleted will not see this event)!!
        }
        #endregion
        #endregion

    }
}