﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;



/// File: MainPage.xaml.cs
/// Author: Kelvin Sung
/// Purpose: show how to load image within the project
/// 

// for BitmapImage
using System.Windows.Media.Imaging;

// for StreamResourceInfo
using System.Windows.Resources;

namespace EnterTextToImage
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();
        }

        #region TextBox service routines
        /// <summary>
        /// "Get Focus" service routine: good hint that user wants to enter something.
        /// Here we simply select all the text, user can choose to erase everything.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void NewTextString(object sender, RoutedEventArgs e)
        {
            mInputBox.SelectAll();
        }

        /// <summary>
        /// "Lost Focus" Service routine: when text input is done will lost focus.
        /// This is a good hint we have a complete string. In this case, verify the input
        /// by echoing it in the label area.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TextEntered(object sender, RoutedEventArgs e)
        {
            mLabel.Text = mInputBox.Text;
        }
        #endregion 

        private void LoadImage(object sender, RoutedEventArgs e)
        {
            BitmapImage img = new BitmapImage();
            Uri uri = new Uri(mInputBox.Text, UriKind.Relative);
            StreamResourceInfo resourceInfo = Application.GetResourceStream(uri);
            if (resourceInfo != null)
            {
                img.SetSource(resourceInfo.Stream);
                mShowImage.Source = img;
            }
            else
                mLabel.Text += ": Image not found";
        }

    }
}