﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;


/// File: MainPage.xaml.cs
/// Author: Kelvin Sung
/// Purpose: show how to work with PhotoChooser and Camera Tasks.
/// 

// for camera and photo chooser support
using Microsoft.Phone.Tasks;

// for BitmapImage
using System.Windows.Media.Imaging;


namespace CameraAndPhotoChooser
{
    public partial class MainPage : PhoneApplicationPage
    {
        CameraCaptureTask mUseCamera;   // Allows the activation of camera task
        PhotoChooserTask mChoosePhoto;  // Allows the activation of photo chooser task

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            // Initialize camrea task and the service function
            mUseCamera = new CameraCaptureTask();
            mUseCamera.Completed += DoneWithPhoto;


            // initialize photo chooser task and the service function
            mChoosePhoto = new PhotoChooserTask();
            mChoosePhoto.Completed += DoneWithPhoto;

            // Notice the photoChoose and Camera service functions can be
            // the same. The service function protocol is the same. 

        }

        /// <summary>
        /// Service routine when a task returns a photo. Convert the photo
        /// to an image for the mShowImage GUI element
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="args"></param>
        void DoneWithPhoto(object sender, PhotoResult args)
        {
            if (args.TaskResult == TaskResult.OK)
            {
                BitmapImage img = new BitmapImage();
                img.SetSource(args.ChosenPhoto);
                mShowImage.Source = img;
            }
        }


        #region Button service routines
        /// <summary>
        /// Photo chooser button service routine. Start photo chooser
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void SelectPhoto(object sender, RoutedEventArgs e)
        {
            try
            {
                mChoosePhoto.Show();
            }
            catch (System.InvalidOperationException ex)
            {
                // in-case this opration fails, let's not crash
            }
        }

        /// <summary>
        /// Camera button service routine. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TakePhoto(object sender, RoutedEventArgs e)
        {
            try
            {
                mUseCamera.Show();
            } 
            catch (System.InvalidOperationException ex)
            {
                // in-case this opration fails, let's not crash
            }
        }
        #endregion
    }
}