﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

// Tasks
using Microsoft.Phone.Tasks;



/// File: MainPage.xaml.cs
/// Author: Kelvin Sung
/// Date: August 11, 2011
/// Purpose: Show how to work with various tasks



namespace _2.AllTheTasks
{
    public partial class MainPage : PhoneApplicationPage
    {

        EmailAddressChooserTask mChooseEmail = new EmailAddressChooserTask();
                // choose an email address

        EmailComposeTask mComposeEmail = new EmailComposeTask();
                // send an composed email

        PhoneCallTask mCallOnPhone = new PhoneCallTask();
                // dial the phone

        PhoneNumberChooserTask mChoosePhoneNumber = new PhoneNumberChooserTask();
                // choose a phone number

        SmsComposeTask mComposeSMS = new SmsComposeTask();
                // send SMS

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            // Call backs
            mChooseEmail.Completed += EmailAddressChosen;
            mChoosePhoneNumber.Completed += PhoneNumberChosen;
        }

        #region Service functions for the corresponding buttons
        private void mEmailAddr_Click(object sender, RoutedEventArgs e)
        {
            mChooseEmail.Show();
        }

        private void mPhoneNum_Click(object sender, RoutedEventArgs e)
        {
            mChoosePhoneNumber.Show();
        }

        private void mSendEmail_Click(object sender, RoutedEventArgs e)
        {
            mComposeEmail.To = "@uw.edu";
            mComposeEmail.Cc = "@uwb.edu";
            mComposeEmail.Subject = "Annoying Student emails";
            mComposeEmail.Body = "Something about one should not do this or that.";
            mComposeEmail.Show();
        }


        private void mPhoneCall_Click(object sender, RoutedEventArgs e)
        {
            mCallOnPhone.PhoneNumber = "xxxyyyzzzz";
            mCallOnPhone.DisplayName = "Some annoying person";
            mCallOnPhone.Show();
        }

        private void SendSMS_Click(object sender, RoutedEventArgs e)
        {
            mComposeSMS.To = "xxxyyyzzzz";
            mComposeSMS.Body = "What a SMS?!";
            mComposeSMS.Show();
        }
        #endregion

        #region Chooser event completed services
        void EmailAddressChosen(Object sender, EmailResult result)
        {
            if (result.TaskResult == TaskResult.OK) 
                mEmailAddrLabel.Text = result.Email;
        }

        void PhoneNumberChosen(Object sender, PhoneNumberResult result)
        {
            if (result.TaskResult == TaskResult.OK)
                mPhoneNumLabel.Text = result.PhoneNumber;
        }
        #endregion 

    }
}