﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

// for Picture and PictureCollection
using Microsoft.Xna.Framework.Media;

// for BitmapImage
using System.Windows.Media.Imaging;


namespace MediaLibraryExample
{
    public partial class MainPage : PhoneApplicationPage
    {
        MediaLibrary mMediaLibrary;
        bool mImageFileNames = false;

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            mMediaLibrary = new MediaLibrary();
            mImageFileNames = false;
        }

        #region Application bar button services
        private void ReadPhoto(object sender, EventArgs e)
        {
            PageTitle.Text = "All Photos";

            mFileNameList.Items.Clear();
            PictureCollection collection = mMediaLibrary.Pictures;
            foreach (Picture p in collection)
            {
                mFileNameList.Items.Add(p.Name);     
            }
            mImageFileNames = true;
        }

        private void ClearPhotos(object sender, EventArgs e)
        {
            mImageFileNames = false; // Must set this to false first
            // as soon as we start adding items into the list, the SelectedNewMedia() function
            // will be called! If we still think we are working with images, program will crash!

            PageTitle.Text = "All Albums";

            mFileNameList.SelectedItem = null;
            mFileNameList.Items.Clear();
            AlbumCollection collection = mMediaLibrary.Albums;
            foreach (Album a in collection)
            {
                mFileNameList.Items.Add(a.Name);
            }
        }
        #endregion


        /// <summary>
        /// Event service routine for SelectionChange on ListBox
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void SelectedNewMedia(object sender, SelectionChangedEventArgs e)
        {
            if (mFileNameList.SelectedIndex >= 0)
            {
                mStatusEcho.Text = mFileNameList.SelectedItem as String;
                if (mImageFileNames)
                {
                    Picture p = mMediaLibrary.Pictures[mFileNameList.SelectedIndex];
                    BitmapImage img = new BitmapImage();
                    img.SetSource(p.GetThumbnail());
                    mSelectedImage.Source = img;
                }
            }
            else
            {
                mStatusEcho.Text = "";
            }
        }

       
    }
}