﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

// for Picture and PictureCollection
using Microsoft.Xna.Framework.Media;

namespace NewPage_Pivot
{
    public partial class MediaInfomation : PhoneApplicationPage
    {
        // MediaLibrary mMediaLibrary;
                // declaring instance variable means we have to allcoate/free this instance 
                // per invocation of the page. Expensive, and the freeing of system resource will dependent
                // on garbaget collection. 
        // Thanks to David Langer (Spring 2012, CSS590) here is a more detailed explanation:
        // http://msdn.microsoft.com/en-us/library/microsoft.xna.framework.media.medialibrary.aspx

        public MediaInfomation()
        {
            InitializeComponent();

            mFilterLabel.Visibility = System.Windows.Visibility.Collapsed;
            mFilterText.Visibility = System.Windows.Visibility.Collapsed;
            mFilterText.Text = "s";
        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);
            mAllPhotos.PopulateFileName();

            mPhotoWithFilter.SetFilter(mFilterText.Text);
            mPhotoWithFilter.PopulateFileName();
        }

       
        private void LoadedPivotItem(object sender, PivotItemEventArgs e)
        {
            if (e.Item == mFilterPivotPage)
            {
                mFilterLabel.Visibility = System.Windows.Visibility.Visible;
                mFilterText.Visibility = System.Windows.Visibility.Visible;
            }
            else
            {
                mFilterLabel.Visibility = System.Windows.Visibility.Collapsed;
                mFilterText.Visibility = System.Windows.Visibility.Collapsed;
            }
        }

        #region Filter Text Box support
        private void FilterTexGetFocus(object sender, RoutedEventArgs e)
        {
            mFilterText.SelectAll();
        }

        private void FilterTextEntered(object sender, RoutedEventArgs e)
        {
            mPhotoWithFilter.SetFilter(mFilterText.Text);
            mFilterPivotPage.Header = "Filter: " + mFilterText.Text;
        }
        #endregion 
    }
}