﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;


// to get Dispatch timer
using System.Windows.Threading;

namespace NewPage_Pivot
{
    public partial class MainPage : PhoneApplicationPage
    {

        #region Timer Support
        // The timer ...
        DispatcherTimer mTimer = new DispatcherTimer();
        int mCount = 0;
        #endregion 

        // Constructor
        public MainPage()
        {
            InitializeComponent();


            #region Timer initialization
            // Updatres every 100 milli second
            mTimer.Interval = TimeSpan.FromMilliseconds(100);
            mTimer.Tick += TimerUpdateRountine;  // What to do when timer ticks
            mTimer.Start();                      // starts the timer
            #endregion 
        }

        #region App Bar button services
        private void PhotoButtonClick(object sender, EventArgs e)
        {
            NavigationService.Navigate(new Uri("/MediaInfomation.xaml", UriKind.Relative));
            // Take a look at:
            //     NavigationService.BackStack; <-- stack of pages
            // If try to
            //     NavigationService.Navigate(new Uri("/MainPage.xaml", UriKind.Relative));
            //     nothing happens
            //
            // From other page, if try to:
            //     NavigationService.Navigate(new Uri("/MainPage.xaml", UriKind.Relative));
            // will wake this page up, but will create a circular reference on the NavigationStack!!
        }
        #endregion


        #region Time Service Routine
        private void TimerUpdateRountine(object sender, EventArgs e)
        {
            mCount++;
            if (mCount >= Int32.MaxValue)
                mCount = 0;
            mTimerEcho.Text = mCount.ToString();
        }
        #endregion

        /// <summary>
        /// Navigation to another page is about to happen, we are about to be gone
        /// </summary>
        /// <param name="e"></param>
        protected override void OnNavigatingFrom(System.Windows.Navigation.NavigatingCancelEventArgs e)
        {
            base.OnNavigatingFrom(e);
            mTimer.Stop();
        }

        /// <summary>
        /// Navigation to another page just finished happening (we are gone)
        /// </summary>
        /// <param name="e"></param>
        protected override void OnNavigatedFrom(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedFrom(e);
        }

        /// <summary>
        /// This page just come alive
        /// </summary>
        /// <param name="e"></param>
        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);
            mTimer.Start();
        }

    }
}