﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

// for Picture and PictureCollection
using Microsoft.Xna.Framework.Media;

namespace NewPage_Pivot
{
    public partial class MediaInfomation : PhoneApplicationPage
    {
        MediaLibrary mMediaLibrary;

        public MediaInfomation()
        {
            InitializeComponent();
            mMediaLibrary = new MediaLibrary();

            mFilterLabel.Visibility = System.Windows.Visibility.Collapsed;
            mFilterText.Visibility = System.Windows.Visibility.Collapsed;
            mFilterText.Text = "s";
        }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);
            mAllPhotos.SetMediaLibrary(mMediaLibrary);

            mPhotoWithFilter.SetFilter(mFilterText.Text);
            mPhotoWithFilter.SetMediaLibrary(mMediaLibrary);
        }

       
        private void LoadedPivotItem(object sender, PivotItemEventArgs e)
        {
            if (e.Item == mFilterPivotPage)
            {
                mFilterLabel.Visibility = System.Windows.Visibility.Visible;
                mFilterText.Visibility = System.Windows.Visibility.Visible;
            }
            else
            {
                mFilterLabel.Visibility = System.Windows.Visibility.Collapsed;
                mFilterText.Visibility = System.Windows.Visibility.Collapsed;
            }
        }

        #region Filter Text Box support
        private void FilterTexGetFocus(object sender, RoutedEventArgs e)
        {
            mFilterText.SelectAll();
        }

        private void FilterTextEntered(object sender, RoutedEventArgs e)
        {
            mPhotoWithFilter.SetFilter(mFilterText.Text);
            mFilterPivotPage.Header = "Filter: " + mFilterText.Text;
        }
        #endregion 
    }
}