﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;


// for Picture and PictureCollection
using Microsoft.Xna.Framework.Media;

// for BitmapImage
using System.Windows.Media.Imaging;


namespace NewPage_Pivot
{
    public partial class PhotoListBox : UserControl
    {
        protected MediaLibrary mMediaLibrary;
        private string mCheckFilter = null;  // only files containing these will be shown, if null, all files are shown

        public PhotoListBox()
        {
            InitializeComponent();
        }

        public void SetMediaLibrary(MediaLibrary m) 
        { 
            mMediaLibrary = m;
            mFileNameList.Items.Clear();

            if (null != mMediaLibrary)
            {
                PictureCollection collection = mMediaLibrary.Pictures;
                foreach (Picture p in collection)
                {
                    if ((null == mCheckFilter) || p.Name.Contains(mCheckFilter))
                        mFileNameList.Items.Add(p.Name);
                }
            }
        }

        public void SetFilter(string f)
        {
            mCheckFilter = f;
            if (null != mMediaLibrary)
                SetMediaLibrary(mMediaLibrary);
        }

        public string GetFilter() { return mCheckFilter; }

        private void SelectedNewMedia(object sender, SelectionChangedEventArgs e)
        {
            if (mFileNameList.SelectedIndex >= 0)
            {
                mStatusEcho.Text = mFileNameList.SelectedItem as String;

                Picture p = mMediaLibrary.Pictures[mFileNameList.SelectedIndex];
                BitmapImage img = new BitmapImage();
                img.SetSource(p.GetThumbnail());
                mSelectedImage.Source = img;
            }
            else
            {
                mSelectedImage.Source = null;
                mStatusEcho.Text = null;
            }
        }
    }
}