﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

namespace ClassExample
{

    internal static class GetRandom
    {
        static private Random mRan = new Random();
        /// <summary>
        /// returns a random number between min to max
        /// </summary>
        /// <param name="min"></param>
        /// <param name="max"></param>
        static public int GetInt(int min, int max)
        {
            return mRan.Next(min, max);
        }

        static public byte[] GetChar(int min, int max)
        {
            int n  = GetInt(min, max);
            byte[] b = new byte[n];
            for (int i = 0; i<n; i++)
                b[i] = (byte) GetInt(48, 126); // thse are the visible characters
            return b;
        }

        static public byte[] GetColor()
        {
            byte[] b = new byte[4];
            for (int i = 0; i<3; i++)
                b[i] = (byte) GetInt(100, 250); // something not too dark
            b[3] = (byte)255; // opaque
            return b;
        }
    }

    #region The data that we are faking
    public class FakeData
    {
        public string Name { get; set; }
        public string ColorName { get; set; }
        public SolidColorBrush ColorBrush { get; set; }

        public FakeData(byte[] name, byte[] cName, byte[] c)
        {
            Name = System.Text.Encoding.UTF8.GetString(name, 0, name.Length);
            ColorName = System.Text.Encoding.UTF8.GetString(cName, 0, cName.Length);
            ColorBrush = new SolidColorBrush(Color.FromArgb(c[0], c[1], c[2], c[3]));
        }
    }
    #endregion

    /// <summary>
    /// Fake data
    /// </summary>
    public class FakeDataSource
    {
        private List<FakeData> mFakeData;
        
        private const int kNameMin = 3;
        private const int kNameMax = 8;

        public FakeDataSource()
        {
            mFakeData = new List<FakeData>();
            int n = GetRandom.GetInt(10, 20); // 10 to 20 records
            for (int i = 0; i < n; i++)
            {
                FakeData d = new FakeData(
                      GetRandom.GetChar(kNameMin, kNameMax), // name
                      GetRandom.GetChar(kNameMin, kNameMax), // cName
                      GetRandom.GetColor());
                mFakeData.Add(d);
            }
        }

        public List<FakeData> GetData()
        {
            return mFakeData;
        }
    }
}