﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;


// Name space for VibrationController
using Microsoft.Devices;


// Accelerometer
// Must add to Reference!
using Microsoft.Devices.Sensors;
using Microsoft.Xna.Framework; // for Vector3 in the AccelerometerReading

// GPS, again must add to reference
//    Notice, GPS is under "System" and not "Microsoft"
using System.Device.Location;



namespace AsyncSensors
{
    public partial class MainPage : PhoneApplicationPage
    {
        // this is the interface to Accelerometer
        Accelerometer mAcc = new Accelerometer();

        // this is the GPS
        // You must switch on Location service for this to work!!
        //     Main Menu => Settings => Location Service (must be enabled!)
        GeoCoordinateWatcher mGeoWatcher;
        // to help resolve current gps location into an addrss
        CivicAddressResolver mGetAddress = new CivicAddressResolver();
            // this is actually not implemented, 
            // included for fun, and serve as an extra example for sync and async response function
            // CivicAddress: Use Bing API (web-client) to resolve civic address (later examples)

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            mGeoWatcher = new GeoCoordinateWatcher(GeoPositionAccuracy.High);
            mGeoWatcher.MovementThreshold = 1; // one meter tolerance
        }

        #region V-button support for Vibration generation

        /// <summary>
        /// Vibrate for 5 seconds. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mVibrateStart_Click(object sender, RoutedEventArgs e)
        {
            VibrateController.Default.Start(TimeSpan.FromSeconds(5));
        }

        /// <summary>
        /// Stops immediately
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mVibrateStop_Click(object sender, RoutedEventArgs e)
        {
            VibrateController.Default.Stop();
        }
        #endregion 

        #region Accelerometer service function

        /// <summary>
        /// Check-box on service
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mAcceOn_Checked(object sender, RoutedEventArgs e)
        {
            mAcceEcho.Text = "... starting Accelerometer";
            try
            {
                // register call back function
                mAcc.CurrentValueChanged += AccelerometerReadingChange;
                mAcc.Start();
            }
            catch (Exception exc)
            {
                mAcceEcho.Text = "Acc start failed!\n" + exc.Message;
            }
        }

        /// <summary>
        /// check box off service
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mAcceOn_Unchecked(object sender, RoutedEventArgs e)
        {
            try
            {
                // unregister the callback and stop
                mAcc.CurrentValueChanged -= AccelerometerReadingChange;
                mAcc.Stop();
            }
            catch (Exception exc)
            {
                mAcceEcho.Text = "Acc stop failed!\n" + exc.Message;
            }
            mAcceEcho.Text = "Accelerometer is Off";
        }

        /// What are we doing here?
        private void AccelerometerReadingChange(object sender, SensorReadingEventArgs<AccelerometerReading> e)
        {
            Vector3 acc = e.SensorReading.Acceleration;

            // verify this following code will crash!! You hope
            //mAcceEcho.Text = "X: " + String.Format("{0:0.0}", acc.X) + "\n" +
            //                 "Y: " + String.Format("{0:0.0}", acc.Y) + "\n" +
            //                 "Z: " + String.Format("{0:0.0}", acc.Z);
            
            Dispatcher.BeginInvoke(
                // _WHAT_ are we doing here?
                () =>
                {
                    // some of the calls may be queued ... must make sure 
                    // accelerometer is ok before setting
                    if (true == mAcceOn.IsChecked)
                            // try removing this line and see display continues after we checked off accelerometers
                            // power and complexity of asyn function calls!
                    {
                        
                        mAcceEcho.Text = "X: " + String.Format("{0:0.000}", acc.X) + "\n" +
                                         "Y: " + String.Format("{0:0.000}", acc.Y) + "\n" +
                                         "Z: " + String.Format("{0:0.000}", acc.Z);
                    }
                });
        }

        
        #endregion

        #region GPS service functions
        private void mGPSOn_Checked(object sender, RoutedEventArgs e)
        {
            mGPSEcho.Text += "\n(Location service enabled?)";
            try
            {
                mGeoWatcher.PositionChanged += PositionChange;
                mGeoWatcher.Start();
            }
            catch (Exception exc)
            {
                mGPSEcho.Text = "GPS starting failed!\n" + exc.Message;
            }
        }

        private void mGPSOn_Unchecked(object sender, RoutedEventArgs e)
        {
            mGPSEcho.Text = "GPS is OFF";
            try
            {
                mGeoWatcher.PositionChanged -= PositionChange;
                mGeoWatcher.Stop();
            }
            catch (Exception exc)
            {
                mGPSEcho.Text = "GPS starting failed!\n" + exc.Message;
            }
        }

        /// <summary>
        /// GPS Service function
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="args"></param>
        void PositionChange(object sender,
                GeoPositionChangedEventArgs<GeoCoordinate> args)
        {
            // this thing-ing again?!
            Dispatcher.BeginInvoke(() =>
            {
                if (true == mGPSOn.IsChecked)
                {
                    mGPSEcho.Text = String.Format("Latitude: {0:F3}\n" +
                                                  "Longitude: {1:F3}\n" +
                                                  "Altitude: {2:F3}\n" + "{3}",
                                                  args.Position.Location.Latitude,
                                                  args.Position.Location.Longitude,
                                                  args.Position.Location.Altitude,
                                                  args.Position.Timestamp);

                    // Or can do this ascyn, but too much trouble for event service function registration
                    // so, let's just do sync inquiry ... makes you wonder if there are 
                    // easier ways of registering for events ...
                    CivicAddress address = mGetAddress.ResolveAddress(args.Position.Location);
                    if (!address.IsUnknown)
                    {
                        mGPSEcho.Text = String.Format("Address: {0} {1}\nCountry: {2}, Zip: {3}",
                            address.AddressLine1,
                            address.AddressLine2,
                            address.CountryRegion,
                            address.PostalCode);
                    }
                }
            });
        }
        #endregion


    }
}