﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;


// Name space for VibrationController
using Microsoft.Devices;


// Accelerometer
// Must add to Reference!
using Microsoft.Devices.Sensors;
using Microsoft.Xna.Framework; // for Vector3 in the AccelerometerReading

// GPS, again must add to reference
//    Notice, GPS is under "System" and not "Microsoft"
using System.Device.Location;



namespace ActionDelegate
{
    public partial class MainPage : PhoneApplicationPage
    {
        // this is the interface to Accelerometer
        Accelerometer mAcc = new Accelerometer();

        // this is the GPS
        GeoCoordinateWatcher mGeoWatcher;
        // to help resolve current gps location into an addrss
        CivicAddressResolver mGetAddress = new CivicAddressResolver();

        #region Action and Delegate definitions
        // Delegate: function pointer data type
        delegate void GPSResponseFunctionType(GeoCoordinate location, DateTimeOffset timestamp);
                // a function pointer that can accept function with the appropriate signature
                // in this case any funciton with the signature:
                //     void XXXXX(GeoCoordinate, DateTimeOffset);

        delegate void AccResponseFunctionType(Vector3 accReadings);
                // a funciton pointer that can accept function with the appropriate signature
                // in this case any function with the signature:
                //      void XXXXX(Vector3);

        // Action: datatype for generic delegate with 1 to 3 parameters
        Action<Vector3> AccResponseAction;   // this is a variable!
                // a delegate of "void" data type that accept one parameter data type of "Vector3"
                // Dispatcher.BeginInvoke() does not support Action with any parameters!!
                // So, cannot use this! Well, too bad.

        GPSResponseFunctionType GPSResponseFunction; // this is a variable
        AccResponseFunctionType AccResponseFunction;
        #endregion 

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            mGeoWatcher = new GeoCoordinateWatcher(GeoPositionAccuracy.High);
            mGeoWatcher.MovementThreshold = 1; // one meter tolerance

            #region Action and Delegate variable initializatoin and event service registration
            //        this is how we would assign value to the variable
            // AccResponseAction = AccResponseService;
            //        this is how one may invoke the value (function) in the variable
            // Vector3 aVec3Obj;
            // AccResponseAction.Invoke(aVec3Obj);

            GPSResponseFunction = GPSResponseService;
            AccResponseFunction = AccResponseService;

            // What is this now?
            // Response funciton to what?
            // If we really want to be lazy, this is what we can do: notice the data type is "optional"!!
            mGetAddress.ResolveAddressCompleted += (sender, e) =>
            // mGetAddress.ResolveAddressCompleted += (Object sender, ResolveAddressCompletedEventArgs e) =>
            {
                if (!e.Address.IsUnknown)
                {
                    mGPSEcho.Text = String.Format("Address: {0} {1}\nCountry: {2}, Zip: {3}",
                        e.Address.AddressLine1,
                        e.Address.AddressLine2,
                        e.Address.CountryRegion,
                        e.Address.PostalCode);
                }
            };
            #endregion
        }

        #region V-button support for Vibration generation

        /// <summary>
        /// Vibrate for 5 seconds. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mVibrateStart_Click(object sender, RoutedEventArgs e)
        {
            VibrateController.Default.Start(TimeSpan.FromSeconds(5));
        }

        /// <summary>
        /// Stops immediately
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mVibrateStop_Click(object sender, RoutedEventArgs e)
        {
            VibrateController.Default.Stop();
        }
        #endregion 

        #region Accelerometer service function

        /// <summary>
        /// Check-box on service
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mAcceOn_Checked(object sender, RoutedEventArgs e)
        {
            mAcceEcho.Text = "... starting Accelerometer";
            try
            {
                // register call back function
                mAcc.CurrentValueChanged += AccelerometerReadingChange;
                mAcc.Start();
            }
            catch (Exception exc)
            {
                mAcceEcho.Text = "Acc start failed!\n" + exc.Message;
            }
        }

        /// <summary>
        /// check box off service
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mAcceOn_Unchecked(object sender, RoutedEventArgs e)
        {
            try
            {
                // unregister the callback and stop
                mAcc.CurrentValueChanged -= AccelerometerReadingChange;
                mAcc.Stop();
            }
            catch (Exception exc)
            {
                mAcceEcho.Text = "Acc stop failed!\n" + exc.Message;
            }
            mAcceEcho.Text = "Accelerometer is Off";
        }

        /// What are we doing here?
        private void AccelerometerReadingChange(object sender, SensorReadingEventArgs<AccelerometerReading> e)
        {
            // verify this following code will crash!! You hope
            // mAcceEcho.Text = "X: " + String.Format("{0:0.0}", e.X) + "\n" +
            //                  "Y: " + String.Format("{0:0.0}", e.Y) + "\n" +
            //                  "Z: " + String.Format("{0:0.0}", e.Z);
            Vector3 acc = e.SensorReading.Acceleration;

            Dispatcher.BeginInvoke(AccResponseFunction, acc);
        }

        private void AccResponseService(Vector3 accReadings)
        {
            // some of the calls may be queued ... must make sure 
            // accelerometer is ok before setting
            if (true == mAcceOn.IsChecked)
            // try removing this line and see display continues after we checked off accelerometers
            // power and complexity of asyn function calls!
            {

                mAcceEcho.Text = "X: " + String.Format("{0:0.000}", accReadings.X) + "\n" +
                                 "Y: " + String.Format("{0:0.000}", accReadings.Y) + "\n" +
                                 "Z: " + String.Format("{0:0.000}", accReadings.Z);
            }
        }
        
        #endregion

        #region GPS service functions
        private void mGPSOn_Checked(object sender, RoutedEventArgs e)
        {
            mGPSEcho.Text += "\n(Location service enabled?)";
            try
            {
                // Now, what are we doing here?
                mGeoWatcher.PositionChanged += (s, arg) => 
                        Dispatcher.BeginInvoke(GPSResponseFunction, arg.Position.Location, arg.Position.Timestamp);

                mGeoWatcher.Start();
            }
            catch (Exception exc)
            {
                mGPSEcho.Text = "GPS starting failed!\n" + exc.Message;
            }
        }

        private void mGPSOn_Unchecked(object sender, RoutedEventArgs e)
        {
            mGPSEcho.Text = "GPS is OFF";
            try
            {
                mGeoWatcher.Stop();
            }
            catch (Exception exc)
            {
                mGPSEcho.Text = "GPS starting failed!\n" + exc.Message;
            }
        }

        private void GPSResponseService(GeoCoordinate location, DateTimeOffset timestamp)
        {
            if (true == mGPSOn.IsChecked)
            {
                mGPSEcho.Text = String.Format("Latitude: {0:F3}\n" +
                                              "Longitude: {1:F3}\n" +
                                              "Altitude: {2}\n" + "{3}",
                                              location.Latitude,
                                              location.Longitude,
                                              location.Altitude,
                                              timestamp);

                // re-call that the response function is defined 
                // (in the constructor of MainPage), we can make our asyn call!
                mGetAddress.ResolveAddressAsync(location);                
            }
        }
        #endregion


    }
}