﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;

// for BitmapImage
using System.Windows.Media.Imaging;

// access to the hardware camera
// DLL to reference is: Microsoft.Phone
using Microsoft.Devices;

namespace CameraAPI
{
    public partial class MainPage : PhoneApplicationPage
    {
        VideoBrush mCameraViewFinder = new VideoBrush();
        ImageBrush mPhotoToShow = new ImageBrush();
        ImageBrush mThumbNailToShow = new ImageBrush();
        PhotoCamera mMyCamera;

        // Constructor
        public MainPage()
        {
            InitializeComponent();
            // set each Canvas' background 
            mCameraView.Background = mCameraViewFinder;
            mPhoto.Background = mPhotoToShow;
            mThumbNail.Background = mThumbNailToShow;
        }

        #region check for camera ready
        // cut/pates from: http://msdn.microsoft.com/en-us/library/hh202956%28v=vs.92%29.aspx
        // under: implementing the ViewFinder and Camera-based events
        //
        //Code for initialization, capture completed, image availability events; also setting the source for the viewfinder.
        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {

            // Check to see if the camera is available on the device.
            if ((PhotoCamera.IsCameraTypeSupported(CameraType.Primary) == true) ||
                 (PhotoCamera.IsCameraTypeSupported(CameraType.FrontFacing) == true))
            {
                // Initialize the camera, when available.
                if (PhotoCamera.IsCameraTypeSupported(CameraType.FrontFacing))
                {
                    // Use front-facing camera if available.
                    mMyCamera = new Microsoft.Devices.PhotoCamera(CameraType.FrontFacing);
                }
                else
                {
                    // Otherwise, use standard camera on back of device.
                    mMyCamera = new Microsoft.Devices.PhotoCamera(CameraType.Primary);
                }

                // Event is fired when the PhotoCamera object has been initialized.
                mMyCamera.Initialized +=new EventHandler<CameraOperationCompletedEventArgs>(mMyCamera_Initialized);

                // Event is fired when the capture sequence is complete.
                // Register for this event if we want to do sometihing
                //   mMyCamera.CaptureCompleted += new EventHandler<CameraOperationCompletedEventArgs>(cam_CaptureCompleted);

                // Event is fired when the capture sequence is complete and an image is available.
                mMyCamera.CaptureImageAvailable += new EventHandler<Microsoft.Devices.ContentReadyEventArgs>(mMyCamera_CaptureImageAvailable);

                // Event is fired when the capture sequence is complete and a thumbnail image is available.
                mMyCamera.CaptureThumbnailAvailable += new EventHandler<ContentReadyEventArgs>(mMyCamera_CaptureThumbnailAvailable);

                //Set the VideoBrush source to the camera.
                mCameraViewFinder.SetSource(mMyCamera);
                mShutterButton.IsEnabled = true;


                // our default is Portrait mode, unfortunately, the camera image needs to be roated ...
                mCameraViewFinder.RelativeTransform = new CompositeTransform() { CenterX = 0.5, CenterY = 0.5, Rotation = 90};

            }
            else
            {
                // The camera is not supported on the device.
                this.Dispatcher.BeginInvoke(delegate()
                {
                    // Write message.
                    mStatus.Text = "No camera on this device.";
                });

                // Disable UI.
                mShutterButton.IsEnabled = false;
            }
        }
        protected override void OnNavigatingFrom(System.Windows.Navigation.NavigatingCancelEventArgs e)
        {
            if (mMyCamera != null)
            {
                // Dispose camera to minimize power consumption and to expedite shutdown.
                mMyCamera.Dispose();

                // Release memory, ensure garbage collection.
                //   Un-register the event functions.
                //   mMyCamera.Initialized -= cam_Initialized;
                //   mMyCamera.CaptureCompleted -= cam_CaptureCompleted;
                //   mMyCamera.CaptureImageAvailable -= cam_CaptureImageAvailable;
                //   mMyCamera.CaptureThumbnailAvailable -= cam_CaptureThumbnailAvailable;
            }
        }
        #endregion

        
        #region Camera Event Services
        // continued cut/pates from: http://msdn.microsoft.com/en-us/library/hh202956%28v=vs.92%29.aspx
        // under: implementing the ViewFinder and Camera-based events
        // 
        // Update the UI if initialization succeeds.
        void mMyCamera_Initialized(object sender, Microsoft.Devices.CameraOperationCompletedEventArgs e)
        {
            if (e.Succeeded)
            {
                Dispatcher.BeginInvoke(delegate()
                {
                    // Write message.
                    mStatus.Text = "Camera initialized.";
                });
            }
        }

        void mMyCamera_CaptureImageAvailable(object sender, Microsoft.Devices.ContentReadyEventArgs e)
        {
            // tell user what happened
            Dispatcher.BeginInvoke(() => {
                mStatus.Text = "Clicked";
                BitmapImage img = new BitmapImage();
                img.SetSource(e.ImageStream);
                mPhotoToShow.ImageSource = img;
            });
        }

        void mMyCamera_CaptureThumbnailAvailable(object sender, Microsoft.Devices.ContentReadyEventArgs e)
        {
            // tell user what happened
            Dispatcher.BeginInvoke(() =>
            {
                mStatus.Text = "Thumb Nail";
                BitmapImage img = new BitmapImage();
                img.SetSource(e.ImageStream);
                mThumbNailToShow.ImageSource = img;
            });
        }

        #endregion


        private void mShutter_Click(object sender, RoutedEventArgs e)
        {
            if (null != mMyCamera)
                mMyCamera.CaptureImage();

        }
    }
}